﻿var synchLogs = {
    context: $(".v-synchronizationLogs"),
    datatable: null,
    synchLogFilter: null,
    treeview: null,
    initializeDataTable: function () {
        this.datatable = $(".h-synchronizationLogsTable", this.context).a4datatable({
            ajaxAction: a4.getAction("GetSynchLogs", "Diagnostics", "Settings"),
            displaySearchBox: true,
            advancedFilter: true,
            height: "full",
            stateKey: "SynchronizationLogs",
            columns: [
                { "Title": resources.LogId, "Data": "LogId", "Visible": false, "HideInSelector": true },
                { "Title": resources.UserId, "Data": "UserId" },
                { "Title": resources.UserName, "Data": "UserName" },
                { "Title": resources.WorkStation, "Data": "WorkStation" },
                { "Title": resources.Server, "Data": "Server", "Visible": false },
                { "Title": resources.DateStart, "Data": "DateStart", "Type": "date" },
                { "Title": resources.DateEnd, "Data": "DateEnd", "Type": "date" },
                { "Title": resources.Result, "Data": "SucessLabel" },
                { "Title": resources.ApplicationVersion, "Data": "ApplicationVersion", "Visible": false },
                { "Title": resources.RemoteIPAddr, "Data": "RemoteIPAddr" },
                { "Title": resources.TotalBytesSent, "Data": "TotalBytesSent", "Visible": false },
                { "Title": resources.TotalBytesReceived, "Data": "TotalBytesReceived", "Visible": false },
                { "Title": resources.Duration, "Data": "Duration", "Visible": false }
            ],
            localizableTexts: { "Search": resources.SearchSynchronizationLogs },
            contextMenuItems: [
                { "Action": "viewDetail", "Label": resources.ViewDetail },
                { "Action": "delete", "Label": resources.Delete },
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "viewDetail":
                        modalDialog.showWindow(a4.getAction("GetSynchLogsDetail", "Diagnostics", "Settings", { syncLogID: row.LogId }), 450, 700);
                        break;
                    case "delete":
                        synchLogs.deleteSynchLogs(row.LogId);
                        break;
                }
            }
        });
    },
    refreshContent: function () {
        synchLogs.datatable.a4datatable("refresh", true);
    },
    deleteSynchLogs: function (syncLogID) {
        modalDialog.showConfirmDelete(confirmDeleteSynchLogsResources, function () {
            a4.callServerMethod(a4.getAction("DeleteSynchLogs", "Diagnostics", "Settings", { syncLogID: syncLogID }), null,
                function () {
                    synchLogs.refreshContent();
                });
        }, 1);
    },

}

$(document).ready(function () {
    if (synchLogs.context.length > 0) {
        synchLogs.initializeDataTable();
    }
});